(*============================================================================*}

  Delphi SDK for using loader APIs ..

(*============================================================================*)

Unit Imploder_SDK;

(*============================================================================*)

Interface

Uses Windows;

(*============================================================================*)
//  Return codes for the functions ..

Const
  RetOK   = 1;
  RetFAIL = 0;

(*============================================================================*)
//  The functions exported by the loader ..

Var
  ArcOpenFile      : Function  (FilenameInArchive : PChar) : DWord; StdCall;
  ArcSizeFile      : Function  (FilenameInArchive : PChar) : DWord; StdCall;
  ArcFileExists    : Function  (FilenameInArchive : PChar) : DWord; StdCall;
  ArcCloseFile     : Procedure (Handle : DWord); StdCall;
  ArcExtractFile   : Function  (FilenameInArchive : PChar; PathToSave : PChar) : DWord; StdCall;

(*============================================================================*)
(*
    Description of functions:

      o  OpenFile
          This function will find and decompress the file from the archive and then allocate memory
           for the file, and copy it there.  The function returns the address of the file in memory.
          The memory is allocated with PAGE_EXECUTE_READWRITE access so you can do whatever you want
           with the data in memory.  With this function you can add anything to your program without
           compiling it with the data included.
          For example, you could add a file called MusicData containing a XM file and in your program
           just do:

          Var
            pMusic : Pointer;
          ..
            pMusic := OpenFile('MusicData');
            ModPlay(pMusic)

      o  CloseFile
          This function removes the memory allocated for the file in the OpenFile function, and if all
           files are closed, free the memory used by the filelist.  You must pass the address returned
           by the OpenFile function.

      o  SizeFile
          This function returns the unpacked size of the specified file in the archive.
          You do not need to use OpenFile to use this function.

      o  FileExists
          This function scans the archive to see if a file exists ..
          You do not need to use OpenFile to use this function.

      o  ExtractFile
          This function will unpack and extract a file from the archive to disk.
          The function will save the file using the name in the archive if no filename is present
           in the PathToSave param.  Also, the path is created if not already existing..
          You do not need to use OpenFile to use this function.

 *)
(*============================================================================*)

Implementation

(*============================================================================*)

Initialization
  ArcOpenFile      := GetProcAddress(0, 'OpenFile');
  ArcSizeFile      := GetProcAddress(0, 'SizeFile');
  ArcCloseFile     := GetProcAddress(0, 'CloseFile');
  ArcFileExists    := GetProcAddress(0, 'FileExists');
  ArcExtractFile   := GetProcAddress(0, 'ExtractFile');
Finalization
End.

